( function( $ ) {//TODO: manage comments

	"use strict";

	var panelMutationObserver = new MutationObserver(function(mutations) {
		// Elementor Search Input
		if ( $('#elementor-panel-elements-search-input').length ) {
			var searchTimeout = null;  
			
			$('#elementor-panel-elements-search-input').on( 'keyup', function(e) {
				if ( e.which === 13 ) {
					return false;
				}

				if (searchTimeout != null) {
					clearTimeout(searchTimeout);
				}

				searchTimeout = setTimeout(function() {
					searchTimeout = null;

					var searchVal = $('#elementor-panel-elements-search-input').val();

					if ( searchVal.includes('par') && $('.wpr-elementor-search-notice').length < 1 ) {
						$('#elementor-panel-elements-wrapper').prepend('\
							<div class="wpr-elementor-search-notice">\
							<strong>Parallax Background</strong> is only available for the Section elements. <strong>Edit any section</strong> > <strong>"Styles"</strong> tab > <strong>"Parallax - Royal Addons"</strong>.\
							</div>\
						');
					}

					elementorCommon.ajax.addRequest( 'wpr_elementor_search_data', {
						data: {
						    search_query: searchVal,
						},
						success: function() {
							// console.log(searchVal);
						}
					});
				}, 1000);
			});
		}

		// Promote Premium Widgets
		if ( $('#elementor-panel-category-wpr-widgets').length ) {
			$('.elementor-element--promotion').on('click', function() {
				var dialogButton = $('.dialog-button');
					dialogButton.hide();

				if ( $(this).find('.wpr-icon').length ) {
					var url = '',
						title = $(this).find('.title').text();

					if ( title === 'My Account') {
						url += 'https://demosites.royal-elementor-addons.com/fashion-v1/my-account-fashion-v1/?ref=rea-plugin-panel-pro-widgets-myacc-seeitinaction';
					} else if ( title === 'Woo Category Grid') {
						url += 'https://demosites.royal-elementor-addons.com/fashion-v1/?ref=rea-plugin-panel-pro-widgets-catgrid-seeitinaction#catgridprev';
					} else if ( title === 'Product Filters') {
						url += 'https://demosites.royal-elementor-addons.com/fashion-v1/shop-fashion-v1/?ref=rea-plugin-panel-pro-widgets-prodfilters-seeitinaction';
					} else if ( title === 'Product Breadcrumbs') {
						url += 'https://demosites.royal-elementor-addons.com/fashion-v1/product/mans-bluish-hoodie/?ref=rea-plugin-panel-pro-widgets-breadcru-seeitinaction';
					}

					if ( !dialogButton.next('a').length ) {
						dialogButton.after('<a href="'+ url +'" target="_blank" class="dialog-button elementor-button elementor-button-success">See it in action</a>');
						dialogButton.next('a').css('display','block');
					} else {
						dialogButton.next('a').attr('href', url);
						dialogButton.next('a').css('display','block');
					}
				} else {
					dialogButton.show();
					dialogButton.next('a').hide();
				}
			});
		}

	});

	// Listen to Elementor Panel Changes
	panelMutationObserver.observe($('#elementor-panel')[0], {
	  childList: true,
	  subtree: true,
	});

	// Make our custom css visible in the panel's front-end
	elementor.hooks.addFilter( 'editor/style/styleText', function( css, context ) {
		if ( ! context ) {
			return;
		}

		var model = context.model,
			customCSS = model.get('settings').get('wpr_custom_css');
		var selector = '.elementor-element.elementor-element-' + model.get('id');
		
		if ( 'document' === model.get('elType') ) {
			selector = elementor.config.document.settings.cssWrapperSelector;
		}

		if ( customCSS ) {
			css += customCSS.replace(/selector/g, selector);
		}

		return css;
	});
	
	// Shortcode Widget: Select Template
	function selectShortcodeTemplate( model, e, select, textarea ) {
			var shortcode = model.attributes.settings.attributes.shortcode,
				shortcode = shortcode.replace ( /[^\d.]/g, '' );

			if ( shortcode === select.val() ) {
				return;
			}

			// Update Settings
			model.attributes.settings.attributes.shortcode = '[wpr-template id="'+ select.val() +'"]';

			// Update Textarea
			textarea.val('[wpr-template id="'+ select.val() +'"]');

			// Refresh Preview
			model.renderRemoteServer();
	}

	elementor.hooks.addAction( 'panel/open_editor/widget/shortcode', function( panel, model, view ) {

		var $select = panel.$el.find('.elementor-control-type-wpr-ajaxselect2'),
			$textarea = panel.$el.find('.elementor-control-type-textarea').find('textarea');

		// Change
		$select.on( 'select2:select', function( e ) {
			selectShortcodeTemplate( model, e, $select, $textarea );
		});

		// Render
		panel.$el.find('#elementor-controls').on( 'DOMNodeInserted ', '.elementor-control-type-wpr-ajaxselect2', function(){
			$(this).find( 'select' ).on( 'select2:select', function( e ) {
				selectShortcodeTemplate( model, e, $select, $textarea );
			} );
		});
	} );

	// WPR Grid Widget: Select Element (Filter Taxonomies)
	function filterGridTaxonomies( data, value ) {
		var options = [];

		for ( var key in data ) {
			if ( key !== value ) {
				for ( var i = 0; i < data[key].length; i++ ) {
					options.push( '.elementor-control-element_select select option[value="'+ data[key][i] +'"]' );
				}
			}
		}

		// Reset
		$( 'head' ).find( '#element_select_filter_style' ).remove();

		if ( 'related' === value || 'current' === value ) {
			return;
		}

		// Append Styles
		$( 'head' ).append('<style id="element_select_filter_style">'+ options.join(',') +' { display: none !important; }</style>');	
	}

	// WPR Grid Widget: Post Meta Keys (Filter by Query)
	function filterGridMetaKeys( data, value ) {
		var options = [];

		for ( var key in data ) {
			if ( key !== value ) {
				for ( var i = 0; i < data[key].length; i++ ) {
					options.push( '.select2-results__options li[data-select2-id*="-'+ data[key][i] +'"]' );
				}
			}
		}

		// Reset
		$( 'head' ).find( '#post_meta_keys_filter_style' ).remove();

		// Append Styles
		$( 'head' ).append('<style id="post_meta_keys_filter_style">'+ options.join(',') +' { display: none !important; }</style>');	
	}

	// WPR Grid Widget / List style: Element Location
	function disableListLocation( value ) {
		// Reset
		$( 'head' ).find( '#list_element_location_style' ).remove();

		if ( 'list' !== value ) {
			return;
		}

		// Append Styles
		$( 'head' ).append('<style id="list_element_location_style">.elementor-control-element_location option[value="above"] { display: none !important; }</style>');	
	}

	// Grid
	elementor.hooks.addAction( 'panel/open_editor/widget/wpr-grid', function( panel, model, view ) {
		var $querySource = panel.$el.find('.elementor-control-query_source').find( 'select' ),
			taxonomies = JSON.parse( panel.$el.find('.elementor-control-element_select_filter').find('input').val() ),
			metaKeys = JSON.parse( panel.$el.find('.elementor-control-post_meta_keys_filter').find('input').val() );

		// Open
		filterGridTaxonomies( taxonomies, $querySource.val() );
		filterGridMetaKeys( metaKeys, $querySource.val() );

		// Change
		$querySource.on( 'change', function() {
			filterGridTaxonomies( taxonomies, $(this).val() );
			filterGridMetaKeys( metaKeys, $(this).val() );
		});

		// Render Query Source
		panel.$el.find('#elementor-controls').on( 'DOMNodeInserted ', '.elementor-control-query_source', function(){
			$(this).find( 'select' ).on( 'change', function() {
				filterGridTaxonomies( taxonomies, $(this).val() );
				filterGridMetaKeys( metaKeys, $(this).val() );
			} );
		});

		// Render Layout Select
		panel.$el.find('#elementor-controls').on( 'DOMNodeInserted ', '.elementor-control-layout_select', function(){
			disableListLocation( $(this).find( 'select' ).val() );

			$(this).find( 'select' ).on( 'change', function() {
				disableListLocation( $(this).val() );
			} );
		});

		// Render Grid Elements
		panel.$el.find('#elementor-controls').on( 'DOMNodeInserted ', '.elementor-control-grid_elements', function() {

			$(this).find( '.elementor-control-element_select select' ).on( 'change', function() {
				var wrapper = $(this).closest( '.elementor-repeater-row-controls' );

				if ( 'lightbox' === $(this).val() ) {
					wrapper.find('.elementor-control-element_location').find( 'select' ).val( 'over' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_animation').find( 'select' ).val( 'fade-in' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_align_hr').find( 'input' ).eq(1).prop('checked',true).trigger( 'change' );
					wrapper.find('.elementor-control-element_lightbox_overlay').find( 'input' ).prop('checked',true).trigger( 'change' );
					wrapper.find('.elementor-control-element_extra_icon_pos').find( 'select' ).val( 'before' ).trigger( 'change' );
					setTimeout(function() {
						wrapper.find('.elementor-control-element_extra_icon_pos').addClass( 'elementor-hidden-control' );
					}, 100 );
				} else {
					wrapper.find('.elementor-control-element_extra_text_pos').find( 'select' ).val( 'none' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_extra_icon_pos').find( 'select' ).val( 'none' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_extra_icon_pos').removeClass( 'elementor-hidden-control' );
				}
			} );
		});

		var sOffsets = {};

		// Prevent Bubble on Click
		panel.$el.find('#elementor-controls').on( 'DOMNodeInserted ', '.elementor-control-type-section', function() {
			var current = $(this),
				attrClass = current.attr( 'class' ),
				firstIndex = attrClass.indexOf( 'elementor-control-section_' ),
				lastIndex = attrClass.indexOf( 'elementor-control-type-section' ) - 1;

			var oKey = attrClass.substring( firstIndex, lastIndex ),
				oProperty = current.offset().top;

			sOffsets[oKey] = oProperty;

			setTimeout(function() {
				current.on( 'click', function( event ) {
					var current = $(this),
						attrClass = current.attr( 'class' ),
						firstIndex = attrClass.indexOf( 'elementor-control-section_' ),
						lastIndex = attrClass.indexOf( 'elementor-control-type-section' ) - 1,
						sectionClass = attrClass.substring( firstIndex, lastIndex );

					setTimeout( function() {
						$( '#elementor-panel-content-wrapper' ).scrollTop( sOffsets[sectionClass] - 100 );
					}, 10 );
				});
			}, 100 );
		});
	} );

	// Image Grid
	elementor.hooks.addAction( 'panel/open_editor/widget/wpr-media-grid', function( panel, model, view ) {
		// Render Grid Elements
		panel.$el.find('#elementor-controls').on( 'DOMNodeInserted ', '.elementor-control-grid_elements', function() {
			$(this).find( '.elementor-control-element_select select' ).on( 'change', function() {
				var wrapper = $(this).closest( '.elementor-repeater-row-controls' );

				if ( 'lightbox' === $(this).val() ) {
					wrapper.find('.elementor-control-element_location').find( 'select' ).val( 'over' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_animation').find( 'select' ).val( 'fade-in' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_align_hr').find( 'input' ).eq(1).prop('checked',true).trigger( 'change' );
					wrapper.find('.elementor-control-element_lightbox_overlay').find( 'input' ).prop('checked',true).trigger( 'change' );
					wrapper.find('.elementor-control-element_extra_icon_pos').find( 'select' ).val( 'before' ).trigger( 'change' );
					setTimeout(function() {
						wrapper.find('.elementor-control-element_extra_icon_pos').addClass( 'elementor-hidden-control' );
					}, 100 );
				} else {
					wrapper.find('.elementor-control-element_extra_text_pos').find( 'select' ).val( 'none' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_extra_icon_pos').find( 'select' ).val( 'none' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_extra_icon_pos').removeClass( 'elementor-hidden-control' );
				}
			} );
		});
	} );

	// Woo Grid
	elementor.hooks.addAction( 'panel/open_editor/widget/wpr-woo-grid', function( panel, model, view ) {
		// Render Grid Elements
		panel.$el.find('#elementor-controls').on( 'DOMNodeInserted ', '.elementor-control-grid_elements', function() {
			$(this).find( '.elementor-control-element_select select' ).on( 'change', function() {
				var wrapper = $(this).closest( '.elementor-repeater-row-controls' );

				if ( 'lightbox' === $(this).val() ) {
					wrapper.find('.elementor-control-element_location').find( 'select' ).val( 'over' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_animation').find( 'select' ).val( 'fade-in' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_align_hr').find( 'input' ).eq(1).prop('checked',true).trigger( 'change' );
					wrapper.find('.elementor-control-element_lightbox_overlay').find( 'input' ).prop('checked',true).trigger( 'change' );
					wrapper.find('.elementor-control-element_extra_icon_pos').find( 'select' ).val( 'before' ).trigger( 'change' );
					setTimeout(function() {
						wrapper.find('.elementor-control-element_extra_icon_pos').addClass( 'elementor-hidden-control' );
					}, 100 );
				} else {
					wrapper.find('.elementor-control-element_extra_text_pos').find( 'select' ).val( 'none' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_extra_icon_pos').find( 'select' ).val( 'none' ).trigger( 'change' );
					wrapper.find('.elementor-control-element_extra_icon_pos').removeClass( 'elementor-hidden-control' );
				}
			} );
		});

		var sOffsets = {};

		// Prevent Bubble on Click - not working - //tmp
		panel.$el.find('#elementor-controls').on( 'DOMNodeInserted ', '.elementor-control-type-section', function() {
			var current = $(this),
				attrClass = current.attr( 'class' ),
				firstIndex = attrClass.indexOf( 'elementor-control-section_' ),
				lastIndex = attrClass.indexOf( 'elementor-control-type-section' ) - 1;

			var oKey = attrClass.substring( firstIndex, lastIndex ),
				oPropery = current.offset().top;

			sOffsets[oKey] = oPropery;

			setTimeout(function() {
				current.on( 'click', function( event ) {
					var current = $(this),
						attrClass = current.attr( 'class' ),
						firstIndex = attrClass.indexOf( 'elementor-control-section_' ),
						lastIndex = attrClass.indexOf( 'elementor-control-type-section' ) - 1,
						sectionClass = attrClass.substring( firstIndex, lastIndex );

					setTimeout( function() {
						$( '#elementor-panel-content-wrapper' ).scrollTop( sOffsets[sectionClass] - 100 );
					}, 10 );
				});
			}, 100 );
		});
	} );

	// Refresh Mega Menu
	elementor.hooks.addAction( 'panel/open_editor/widget/wpr-mega-menu', function( panel, model, view ) {
		model.renderRemoteServer();
	});

	// Get Referrer Link
	var referrer = document.referrer;

	// Return to Plugin Page
	if ( '' !== referrer && referrer.indexOf( 'page=wpr-addons' ) > -1 ) {
		$(window).on( 'load', function() {

			$('#elementor-panel-header-menu-button').on( 'click', function() {

				setTimeout(function() {
					$('.elementor-panel-menu-item-exit-to-dashboard').on( 'click', function() {
						window.location.href = referrer;
					});
				}, 300);
			});
		});
	}

	// Advanced Slider - TODO: Check if necessary or remove
	// elementor.hooks.addAction( 'panel/open_editor/widget/wpr-advanced-slider', function( panel, model, view ) {
	// 	var elControls = panel.$el,
	// 		$select = elControls.find('.elementor-control-slider_content_type').find('select');

	// 	if ( 'custom' !== $select.val() ) {
	// 		elControls.find('.elementor-control-slider_items .elementor-repeater-row-controls .elementor-control').addClass('wpr-elementor-hidden-control');
	// 		elControls.find('.elementor-control-slider_content_type').removeClass('wpr-elementor-hidden-control');
	// 		elControls.find('.elementor-control-slider_select_template').removeClass('wpr-elementor-hidden-control');
	// 	} else {
	// 		elControls.find('.elementor-control-slider_items .elementor-repeater-row-controls .elementor-control').removeClass('wpr-elementor-hidden-control');
	// 		elControls.find('.elementor-control-slider_select_template').addClass('wpr-elementor-hidden-control');
	// 	}

	// 	$select.on( 'change', function() {

	// 		if ( 'custom' !== $(this).val() ) {
	// 			elControls.find('.elementor-control-slider_items .elementor-repeater-row-controls .elementor-control').addClass('wpr-elementor-hidden-control');
	// 			elControls.find('.elementor-control-slider_content_type').removeClass('wpr-elementor-hidden-control');
	// 			elControls.find('.elementor-control-slider_select_template').removeClass('wpr-elementor-hidden-control');
	// 		} else {
	// 			elControls.find('.elementor-control-slider_items .elementor-repeater-row-controls .elementor-control').removeClass('wpr-elementor-hidden-control');
	// 			elControls.find('.elementor-control-slider_select_template').addClass('wpr-elementor-hidden-control');
	// 		}			
	// 	});
	// } );

	/*--------------------------------------------------------------
	== Widget Preview and Library buttons
	--------------------------------------------------------------*/

	for (const [key, value] of Object.entries(registered_modules)) {
		elementor.hooks.addAction( 'panel/open_editor/widget/wpr-'+ value[0], function( panel, model, view ) {
			openPedefinedStyles( panel.$el, view.$el, value[0], value[1], value[2] );
		} );
	}

	function openPedefinedStyles( panel, preview, widget, url, filter ) {
		panel.on( 'click', '.elementor-control-wpr_library_buttons .elementor-control-raw-html div a:first-child', function() {
			var theme = $(this).data('theme');
			$(this).attr('href', url +'?ref=rea-plugin-panel-'+ widget +'-utmtr'+ theme.slice(0,3) +'nkbs'+ theme.slice(3,theme.length) +'-preview'+ filter);
		});

		panel.on( 'click', '.elementor-control-wpr_library_buttons .elementor-control-raw-html div a:last-child', function() {
			preview.closest('body').find('#wpr-library-btn').attr('data-filter', widget);
			preview.closest('body').find('#wpr-library-btn').trigger('click');
		});
	}

	/*--------------------------------------------------------------
	== Reload Theme Builder
	--------------------------------------------------------------*/
	elementor.once('document:loaded', function(){
		setTimeout(function(){
			if ( $('body').hasClass('elementor-editor-wpr-theme-builder') ) {
				elementor.reloadPreview();
			}
		}, 10);
	});

}( jQuery ) );

( function( $ ) {

	'use strict';

	var WprMegaMenuEditor = {

		activeSection: false,

		currentElement: false,

		currentSection: false,

		prevSection: false,


		init: function() {
			elementor.channels.editor.on( 'section:activated', WprMegaMenuEditor.sectionActivated );
		},

		sectionActivated: function( sectionName, editor ) {

			let currentElement = WprMegaMenuEditor.currentElement = editor.getOption( 'editedElementView' ) || false;

			if ( ! currentElement ) {
				return;
			}

			if ( 'wpr-mega-menu' == currentElement.model.get( 'widgetType' ) ) {

				// if ( 'section_general' === sectionName ) {}
				// currentElement.model.renderRemoteServer();
			}

		}

	};

	$( window ).on( 'elementor:init', WprMegaMenuEditor.init );

	window.WprMegaMenuEditor = WprMegaMenuEditor;

}( jQuery ) );
